﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Win32;
using Winfoot_7_SDK;

namespace WinfootDefaultPerformancePlugin.Controls.Strategy
{
    public interface ICompressOldFilesStrategy
    {
        void Write(bool b);
        WFRegistry Read();
        List<WFRegistry> BackUp();
    }

    public class CompressOldFilesDefaultStrategy : ICorrespondenceOS, ICompressOldFilesStrategy
    {
        public CompressOldFilesDefaultStrategy()
        {
            CorrespondenceOSList = new List<OS>
                                       {
                                           OS.WindowsXP,
                                           OS.WindoesXP_SP1,
                                           OS.WindowsXP_SP2,
                                           OS.WindowsXP_SP3,
#if DEBUG
                                           OS.WindowsVista,
                                           OS.WindowsVista_SP1,
                                           OS.WindowsSeven
#endif
                                       };
        }

        #region ICorrespondenceOS メンバ

        public List<OS> CorrespondenceOSList { get; set; }

        #endregion


        public void Write(bool b)
        {
            if (b)
            {
                Registry.LocalMachine.CreateSubKey(
                    @"\SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\VolumeCaches\Compress old files");
            }
            else
            {
                Registry.LocalMachine.DeleteSubKey(
                    @"\SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\VolumeCaches\Compress old files");
            }
        }

        public WFRegistry Read()
        {
            RegistryKey registryKey =
                Registry.LocalMachine.OpenSubKey(
                    @"\SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\VolumeCaches\Compress old files");
            if (registryKey != null)
            {
                return
                    new WFRegistry(
                        @"HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\VolumeCaches\Compress old files",
                        "LinkResolveIgnoreLinkInfo", registryKey.GetValue("", ""),
                        RegistryValueKind.String, RegOperation.KeyWrite);
            }
            return
                new WFRegistry(
                    @"HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\VolumeCaches\Compress old files",
                    "", "", RegistryValueKind.String, RegOperation.KeyDel);
        }

        public List<WFRegistry> BackUp()
        {
            return new List<WFRegistry> {Read()};
        }

    }

    public class CompressOldFilesController
    {
        public CompressOldFilesController(CompressOldFiles compressOldFiles, ICompressOldFilesStrategy strategy)
        {
            CompressOldFiles = compressOldFiles;
            Strategy = strategy;
        }

        public CompressOldFiles CompressOldFiles { get; set; }
        public ICompressOldFilesStrategy Strategy { get; set; }

        public void Read()
        {
            WFRegistry wfRegistry = Strategy.Read();
            switch (wfRegistry.RegOperation)
            {
                case RegOperation.KeyWrite:
                    CompressOldFiles.SetCompressOldFilesState(true);
                    break;
                default:
                    CompressOldFiles.SetCompressOldFilesState(false);
                    break;
            }
        }

        public void Write()
        {
            Strategy.Write(CompressOldFiles.GetCompressOldFilesState());
        }

        public List<WFRegistry> BackUp()
        {
            return Strategy.BackUp();
        }
    }
}